﻿using System;
using System.Collections.Generic;

namespace MurkaDbMap
{
    public class DbTablesDescription
    {
        private readonly Dictionary<MainDatabaseDescription.ETables, DbTableFieldDescription> _tablesMap = new Dictionary<MainDatabaseDescription.ETables, DbTableFieldDescription>();

        public void Add(MainDatabaseDescription.ETables key, DbTableFieldDescription tableFieldDescription)
        {
            if (!_tablesMap.ContainsKey(key))
            {
                _tablesMap.Add(key, tableFieldDescription);
            }
            else
            {
                //TODO error handling
            }
        }

        public DbTableFieldDescription GetTable(MainDatabaseDescription.ETables key)
        {
            DbTableFieldDescription ret = null;
            if (_tablesMap.ContainsKey(key))
            {
                ret = _tablesMap[key];
            }
            return ret;
        }

        public void WriteToConsole()
        {
            foreach (KeyValuePair<MainDatabaseDescription.ETables, DbTableFieldDescription> dbTableFieldDescription in _tablesMap)
            {
                dbTableFieldDescription.Value.WriteToConsole();
            }
        }

        public string GetFieldName(MainDatabaseDescription.ETables table, MainDatabaseDescription.EFields field)
        {
            DbTableFieldDescription tableFieldDescription = GetTable(table);
            if (tableFieldDescription != null)
            {
                return tableFieldDescription.GetFieldName(field);
            }
            return "**Not found**";
        }
    }
}