﻿using System;
using System.Collections.Generic;

namespace MurkaDbMap
{
    public abstract class DbTableFieldDescription
    {
        private readonly DbFieldsDescription _fields = new DbFieldsDescription();

        private readonly MainDatabaseDescription.ETables _id;

        private readonly string _tableName;

        protected DbTableFieldDescription(MainDatabaseDescription.ETables id, string tableName)
        {
            _id = id;
            _tableName = tableName;

            //for sample and quicktest
            Init();
        }

        protected void Add(MainDatabaseDescription.EFields key, string name)
        {
            _fields.Add(key, name);
        }

        public string GetFieldName(MainDatabaseDescription.EFields key, bool fullName = false)
        {
            if (fullName)
            {
                return string.Format("{0}.{1}", _tableName, _fields.GetName(key));
            }
            return _fields.GetName(key);
        }

        protected abstract void Init();

        public void WriteToConsole()
        {
            Console.WriteLine("--------{0}---------", TableName);
            IEnumerable<KeyValuePair<MainDatabaseDescription.EFields, string>> pairs = _fields.GetAllFilds();
            foreach (KeyValuePair<MainDatabaseDescription.EFields, string> pair in pairs)
            {
                Console.WriteLine("\t{0}", GetFieldName(pair.Key, true));
            }
            //foreach (var field in _fields)
            //{
            //    throw new NotImplementedException();
            //}
        }

        public MainDatabaseDescription.ETables Id
        {
            get
            {
                return _id;
            }
        }

        public string TableName
        {
            get
            {
                return _tableName;
            }
        }
    }
}