﻿using System.Collections.Generic;

namespace MurkaDbMap
{
    public class DbFieldsDescription
    {
        private readonly Dictionary<MainDatabaseDescription.EFields,string> _namesMap = new Dictionary<MainDatabaseDescription.EFields, string>();

        public void Add(MainDatabaseDescription.EFields key, string name)
        {
            if (!_namesMap.ContainsKey(key))
            {
                _namesMap.Add(key,name);
            }
            else
            {
                //TODO error handling
            }
        }

        public string GetName(MainDatabaseDescription.EFields key)
        {
            string ret = "Not Found";
            if (_namesMap.ContainsKey(key))
            {
                ret = _namesMap[key];
            }
            return ret;
        }

        public IEnumerable<KeyValuePair<MainDatabaseDescription.EFields, string>> GetAllFilds()
        {
            foreach (KeyValuePair<MainDatabaseDescription.EFields, string> pair in _namesMap)
            {
                yield return pair;
            }
        }
    }
}